// URL: http://slice-vps.nl/ppg/#gist=b084bef18ae325e5150f

/******************************************************************************/
/*                      * K - Loading Screen *                                */
/*                      *       3.0          *                                */
/*                      * Kavinsky Script    *                                */
/*       * Thanks Phanto90 for helping me with function 'UpdateBar' *         */
/******************************************************************************/

// Include
#include <a_samp>

// Forward
forward UpdateBar(playerid,stepp);
forward HideTD(playerid);
forward ShowTD(playerid);

// Define
#define USE_CLEAR_SCREEN	true //Use 'false' to not clean the chat

// Variables
new
	Text:Sprite0, //New
	Text:Bar0, //New
	Text:Loading0; //New

new
	step[MAX_PLAYERS];

new Texture[][] =
{
	"loadsc9:loadsc9",
	"loadsuk:loadscuk",
	"splash1:splash2",
	"splash1:splash1",
	"LOADSUK:loadsc14",
	"LOADSUK:loadsc13",
	"LOADSUK:loadsc12",
	"LOADSUK:loadsc11",
	"LOADSUK:loadsc10",
	"LOADSUK:loadsc9",
	"LOADSUK:loadsc8",
	"LOADSUK:loadsc7",
	"LOADSUK:loadsc6",
	"LOADSUK:loadsc5",
	"LOADSUK:loadsc4",
	"LOADSUK:loadsc3",
	"LOADSUK:loadsc2",
	"LOADSUK:loadsc1"
};

public OnFilterScriptInit()
{
	print("------------------------------------------------------------------");
	print("Kavinsky Loading Screen 3.0 by Kavinsky for SA-MP 0.3e Loaded!");
	print("------------------------------------------------------------------");

	// Sprite
	new TT = random(sizeof(Texture));
    Sprite0 = TextDrawCreate(-0.500, -0.500,Texture[TT]);
    TextDrawFont(Sprite0, 4);
    TextDrawTextSize(Sprite0, 647.500, 457.000);
    TextDrawColor(Sprite0, -1);

    // Bar
	Bar0 = TextDrawCreate(413.000000, 383.000000, "IIIIIIIIIIIIIIIIIIIIII");
	TextDrawBackgroundColor(Bar0, 255);
	TextDrawFont(Bar0, 1);
	TextDrawLetterSize(Bar0, 0.330000, 1.000000);
	TextDrawColor(Bar0, -16776961);
	TextDrawSetOutline(Bar0, 1);
	TextDrawSetProportional(Bar0, 1);
	TextDrawUseBox(Bar0, 1);
	TextDrawBoxColor(Bar0, 255);
	TextDrawTextSize(Bar0, 500.000000, 0.000000);


	//Loading
	Loading0 = TextDrawCreate(410.000000, 370.000000, "Loading...");
	TextDrawBackgroundColor(Loading0, 255);
	TextDrawFont(Loading0, 1);
	TextDrawLetterSize(Loading0, 0.360000, 1.000000);
	TextDrawColor(Loading0, -1);
	TextDrawSetOutline(Loading0, 1);
	TextDrawSetProportional(Loading0, 1);
	return 1;
}
public OnFilterScriptExit()
{
	TextDrawDestroy(Sprite0);
	TextDrawDestroy(Bar0);
	TextDrawDestroy(Loading0);
	return 1;
}
public UpdateBar(playerid,stepp)
{
    if(step[playerid] == 21) return SetTimerEx("HideTD",500,0,"i",playerid);
    new substring[22];
    for(new i; i<step[playerid]+1; i++)
    strins(substring, "I", strlen(substring));
    TextDrawSetString(Bar0,substring);
    TextDrawShowForPlayer(playerid,Bar0);
    step[playerid]++;
    return 1;
}

public OnPlayerSpawn(playerid)
{
	if(GetPVarInt(playerid, "ScreenShow") == 0)
	{
	    SetPlayerInterior(playerid,0);
		SetTimerEx("ShowTD",250,0,"i",playerid);
	}
	return 1;
}

public OnPlayerDeath(playerid, killerid)
{
	SetPVarInt(playerid, "ScreenShow", 1);
}

public ShowTD(playerid)
{
    TextDrawShowForPlayer(playerid,Sprite0);
    TextDrawShowForPlayer(playerid,Bar0);
    TextDrawShowForPlayer(playerid,Loading0);
    SetTimerEx("UpdateBar",200,1,"i",playerid);
    #if USE_CLEAR_SCREEN == true
	ClearScreen(playerid,20);
	#endif
	return 1;
}
public HideTD(playerid)
{
    TextDrawHideForPlayer(playerid,Sprite0);
	TextDrawHideForPlayer(playerid,Bar0);
	TextDrawHideForPlayer(playerid,Loading0);
    return 1;
}

ClearScreen(playerid,lines)
{
    for(new i; i <= lines; i++)
    {
        SendClientMessage(playerid,-1,"");
    }
    return 1;
}
